# Mpesa MiniShop & eCommerce

**Mpesa MiniShop** is now a complete **eCommerce Solution** for WordPress tailored for the Kenyan market. It transforms your site into a fully functional online store with built-in M-Pesa STK Push payments—no extra plugins (like WooCommerce) required.

## 🚀 Key Features

*   **🛒 Complete eCommerce System**:
    *   **Automated Pages**: Instantly creates **Shop**, **Cart**, **Checkout**, and **Order Received** pages upon activation.
    *   **Product Management**: Sell **Physical**, **Virtual**, and **Downloadable** products.
    *   **Shopping Cart**: Fast, cookie-based cart system that works perfectly on mobile.
*   **💳 Native M-Pesa Integration**:
    *   **STK Push**: Seamless "Lipa Na M-Pesa Online" checkout experience.
    *   **Secure**: Validates payments automatically via Safaricom callbacks.
*   **🎨 Professional UI**:
    *   **Modern Design**: Beautiful product grids, floating cards, and a premium 2-column checkout.
    *   **Responsive**: Optimized for phones and tablets.
*   **📊 Admin Dashboard**:
    *   **Sales Analytics**: Track revenue and daily sales.
    *   **Order Management**: View and manage orders directly from the WordPress dashboard.

## 🛠️ Installation

1.  Upload the `Mpesa-MiniShop` folder to `wp-content/plugins/` or install via the Admin dashboard.
2.  **Activate** the plugin.
    *   *Note*: The plugin will automatically create the necessary pages (Shop, Cart, Checkout).
3.  Go to **Mpesa Gateway > Settings** to configure your API keys.

## ⚙️ Configuration

1.  **Get Credentials**: Sign up at [Safaricom Developer Portal](https://developer.safaricom.co.ke/).
2.  **Enter Keys**:
    *   Go to **Mpesa Gateway > Settings**.
    *   Enter your **Consumer Key**, **Consumer Secret**, **Passkey**, and **Shortcode**.
    *   Select `Sandbox` for testing or `Live` to start selling.

## 📦 Selling Products

1.  Go to **Mpesa Gateway > Products** > **Add New**.
2.  Enter the Product Title and Description.
3.  Set the **Price** and **Product Type** (Physical, Virtual, Downloadable).
4.  Add a **Featured Image**.
5.  **Publish!**
    *   The product will automatically appear on your **Shop** page (`/shop/`).

## 📁 Shortcodes (Optional)

While pages are created automatically, you can place these shortcodes manually if you want custom layouts:

*   `[mpesa_cart]` - Displays the Shopping Cart.
*   `[mpesa_checkout]` - Displays the Multi-step Checkout Form.
*   `[mpesa_stk_push]` - Simple pay-only form (legacy mode).

## 🤝 Contributing

Created by **KK Dynamic Enterprise Solutions Ltd, Alex K Metto**.
Contributions are welcome!
