<?php

class Mpesa_Minishop_Admin {

    private $option_name = 'mpesa_minishop_settings';

    public function add_plugin_page() {
        add_menu_page(
            'Mpesa Minishop',
            'Mpesa Minishop',
            'manage_options',
            'mpesa-minishop-dashboard',
            array( $this, 'render_dashboard_page' ),
            'dashicons-money',
            56
        );

        add_submenu_page(
            'mpesa-minishop-dashboard',
            'Dashboard',
            'Dashboard',
            'manage_options',
            'mpesa-minishop-dashboard',
            array( $this, 'render_dashboard_page' )
        );

        add_submenu_page(
            'mpesa-minishop-dashboard',
            'Settings',
            'Settings',
            'manage_options',
            'mpesa-minishop-settings',
            array( $this, 'render_settings_page' )
        );
    }

    public function enqueue_styles( $hook ) {
        if ( strpos( $hook, 'mpesa-minishop' ) !== false ) {
            wp_enqueue_style( 'mpesa-minishop-admin', MPESA_MINISHOP_URL . 'assets/css/admin.css', array(), MPESA_MINISHOP_VERSION );
        }
    }

    public function render_dashboard_page() {
        require_once MPESA_MINISHOP_PATH . 'admin/class-mpesa-minishop-dashboard.php';
        $dashboard = new Mpesa_Minishop_Dashboard();
        $dashboard->render();
    }

    public function render_settings_page() {
        ?>
        <div class="wrap mpesa-settings-wrap">
            <h1>Mpesa Minishop Settings</h1>
            <form method="post" action="options.php">
                <?php
                settings_fields( 'mpesa_minishop_group' );
                do_settings_sections( 'mpesa-minishop-settings' );
                submit_button();
                ?>
            </form>
        </div>
        <?php
    }

    public function register_settings() {
        register_setting( 'mpesa_minishop_group', $this->option_name, array( $this, 'sanitize_settings' ) );
        
        add_settings_section( 'mpesa_api_creds', 'API Credentials', null, 'mpesa-minishop-settings' );

        $fields = array(
            'environment' => array('label' => 'Environment', 'type' => 'select', 'options' => array('sandbox' => 'Sandbox', 'live' => 'Live')),
            'consumer_key' => array('label' => 'Consumer Key', 'type' => 'text'),
            'consumer_secret' => array('label' => 'Consumer Secret', 'type' => 'password'),
            'shortcode' => array('label' => 'Business Shortcode', 'type' => 'text'),
            'passkey' => array('label' => 'Passkey', 'type' => 'password'),
            'callback_url' => array('label' => 'Callback URL', 'type' => 'text', 'desc' => 'Default: ' . home_url('/wp-json/mpesa-minishop/v1/callback')),
        );

        foreach($fields as $id => $field) {
            add_settings_field(
                $id,
                $field['label'],
                array( $this, 'render_field' ),
                'mpesa-minishop-settings',
                'mpesa_api_creds',
                array( 'id' => $id, 'field' => $field )
            );
        }
    }

    public function render_field( $args ) {
        $options = get_option( $this->option_name );
        $id = $args['id'];
        $field = $args['field'];
        $val = isset( $options[$id] ) ? $options[$id] : '';

        if( $field['type'] == 'select' ) {
            echo '<select name="'.$this->option_name.'['.$id.']">';
            foreach($field['options'] as $k => $v) {
                $selected = ($val == $k) ? 'selected' : '';
                echo "<option value='$k' $selected>$v</option>";
            }
            echo '</select>';
        } else {
            $type = $field['type'];
            echo "<input type='$type' name='".$this->option_name."[$id]' value='".esc_attr($val)."' class='regular-text'>";
        }

        if(isset($field['desc'])) {
            echo "<p class='description'>{$field['desc']}</p>";
        }
    }
    public function sanitize_settings( $input ) {
        $sanitized_input = array();
        if( isset( $input['environment'] ) ) {
            $sanitized_input['environment'] = sanitize_text_field( $input['environment'] );
        }
        if( isset( $input['consumer_key'] ) ) {
            $sanitized_input['consumer_key'] = sanitize_text_field( $input['consumer_key'] );
        }
        if( isset( $input['consumer_secret'] ) ) {
            $sanitized_input['consumer_secret'] = sanitize_text_field( $input['consumer_secret'] );
        }
        if( isset( $input['shortcode'] ) ) {
            $sanitized_input['shortcode'] = sanitize_text_field( $input['shortcode'] );
        }
        if( isset( $input['passkey'] ) ) {
            $sanitized_input['passkey'] = sanitize_text_field( $input['passkey'] );
        }
        if( isset( $input['callback_url'] ) ) {
            $sanitized_input['callback_url'] = esc_url_raw( $input['callback_url'] );
        }
        return $sanitized_input;
    }
}
