<?php

class Mpesa_Minishop_Template_Loader {

    public function init() {
        add_filter( 'template_include', array( $this, 'load_template' ) );
    }

    public function load_template( $template ) {
        if ( is_post_type_archive( 'mpesa_product' ) || is_page( get_option( 'mpesa_shop_page_id' ) ) ) {
            $new_template = $this->get_template_path( 'archive-mpesa_product.php' );
            if ( $new_template ) return $new_template;
        }

        if ( is_singular( 'mpesa_product' ) ) {
            $new_template = $this->get_template_path( 'single-mpesa_product.php' );
            if ( $new_template ) return $new_template;
        }

        return $template;
    }

    private function get_template_path( $filename ) {
        // Check theme override first: your-theme/mpesa-minishop/filename.php
        $theme_path = locate_template( array( 'mpesa-minishop/' . $filename ) );
        if ( $theme_path ) {
            return $theme_path;
        }

        // Check plugin templates
        $plugin_path = MPESA_MINISHOP_PATH . 'templates/' . $filename;
        if ( file_exists( $plugin_path ) ) {
            return $plugin_path;
        }

        return false;
    }
}
