<?php
/**
 * Plugin Name: Mpesa Minishop
 * Plugin URI:  https://kkdes.co.ke/mpesa-stk-push-payment-wordpress-ecommerce-pos/
 * Description: A complete, professional M-Pesa STK Push payment and minishop solution for WordPress.
 * Version:     1.0.1
 * Author:      Alex K Metto
 * Text Domain: mpesa-minishop
 * License:     GPLv2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define Constants
define( 'MPESA_MINISHOP_VERSION', '1.0.1' );
define( 'MPESA_MINISHOP_PATH', plugin_dir_path( __FILE__ ) );
define( 'MPESA_MINISHOP_URL', plugin_dir_url( __FILE__ ) );

/**
 * Main Plugin Class
 */
class Mpesa_Minishop {

	public function run() {
		$this->load_dependencies();
		$this->define_admin_hooks();
		$this->define_public_hooks();
        add_action( 'init', array( $this, 'start_session' ), 1 );
	}

    public function start_session() {
        if ( ! session_id() ) {
            session_start();
        }
    }

	private function load_dependencies() {
		require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-db.php';
		require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-api.php';
        require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-cpt.php';
        require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-install.php';
		require_once MPESA_MINISHOP_PATH . 'admin/class-mpesa-minishop-admin.php';
		require_once MPESA_MINISHOP_PATH . 'public/class-mpesa-minishop-public.php';
        require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-cart.php';
        require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-pos.php';

        require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-template-loader.php';

        $cpt = new Mpesa_Minishop_CPT();
        $cpt->init();

        $loader = new Mpesa_Minishop_Template_Loader();
        $loader->init();

        $pos = new Mpesa_Minishop_POS();
        $pos->init();
	}

	private function define_admin_hooks() {
		$plugin_admin = new Mpesa_Minishop_Admin();
		add_action( 'admin_menu', array( $plugin_admin, 'add_plugin_page' ) );
		add_action( 'admin_init', array( $plugin_admin, 'register_settings' ) );
        add_action( 'admin_enqueue_scripts', array( $plugin_admin, 'enqueue_styles' ) );
	}

	private function define_public_hooks() {
		$plugin_public = new Mpesa_Minishop_Public();
		add_shortcode( 'mpesa_stk_push', array( $plugin_public, 'render_form' ) );
        add_shortcode( 'stk_push_form', array( $plugin_public, 'render_form' ) ); 
        add_shortcode( 'mpesa_cart', array( $plugin_public, 'render_cart' ) );
        add_shortcode( 'mpesa_checkout', array( $plugin_public, 'render_checkout' ) );

		add_action( 'wp_enqueue_scripts', array( $plugin_public, 'enqueue_scripts' ) );
		add_action( 'wp_ajax_mpesa_initiate', array( $plugin_public, 'initiate_payment' ) );
		add_action( 'wp_ajax_nopriv_mpesa_initiate', array( $plugin_public, 'initiate_payment' ) );

        add_action( 'wp_ajax_mpesa_add_to_cart', array( $plugin_public, 'ajax_add_to_cart' ) );
        add_action( 'wp_ajax_nopriv_mpesa_add_to_cart', array( $plugin_public, 'ajax_add_to_cart' ) );

        add_action( 'wp_ajax_mpesa_process_checkout', array( $plugin_public, 'ajax_process_checkout' ) );
        add_action( 'wp_ajax_nopriv_mpesa_process_checkout', array( $plugin_public, 'ajax_process_checkout' ) );
        
        // Callback handler
        add_action( 'rest_api_init', array( new Mpesa_Minishop_API(), 'register_callback_route' ) );
	}
}

// Activation Hook
register_activation_hook( __FILE__, array( 'Mpesa_Minishop_Activator', 'activate' ) );

class Mpesa_Minishop_Activator {
	public static function activate() {
		require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-db.php';
        require_once MPESA_MINISHOP_PATH . 'includes/class-mpesa-minishop-install.php';
		Mpesa_Minishop_DB::create_table();
        Mpesa_Minishop_Install::install();
	}
}

// Initialize
$plugin = new Mpesa_Minishop();
$plugin->run();
